///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//  Copyright  NetworkDLS 2002, All rights reserved
//
// THIS CODE AND INFORMATION IS PROVIDED "AS IS" WITHOUT WARRANTY OF 
// ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING BUT NOT LIMITED TO 
// THE IMPLIED WARRANTIES OF MERCHANTABILITY AND/OR FITNESS FOR A 
// PARTICULAR PURPOSE.
///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
#ifndef NetworkDLS_Algorithmic_Symmetric_Cipher_Cryptography_Library_HashKey_Cpp
#define NetworkDLS_Algorithmic_Symmetric_Cipher_Cryptography_Library_HashKey_Cpp
////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

#include "STDIO.H"
#include "Windows.H"
#include "NASCCL.H"

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

int NASCCL::CipherKey(const void *sRawKey, void *sKeyHash, int iRawKeySz)
{
	return HashKey(sRawKey, sKeyHash, iRawKeySz, iRawKeySz);
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

int NASCCL::HashKey(const void *sRawKey, void *sKeyHash, int iRawKeySz, int iKeyHashSz)
{
	int iRPos = 0;
	int iWPos = 0;
	int iSBox = 0;

	while(iWPos < iKeyHashSz)
	{
		if(iRPos == iRawKeySz)
		{
			iRPos = 0;
		}

		if(iSBox == SALT_BOXES)
		{
			iSBox = 0;
		}

		((NTYPE *)sKeyHash)[iWPos] = (((NTYPE *)sRawKey)[iRPos] ^
			(((NTYPE *)sRawKey)[iRPos] + sHardSalt[iSBox][((NTYPE *)sRawKey)[iRPos]]))
			+ (iRPos + iWPos + iSBox);

		iRPos++;
		iWPos++;
		iSBox++;
	}

	((NTYPE *)sKeyHash)[iWPos] = '\0';

	return iWPos;
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
#endif
